/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.translations.components;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import net.impactdev.impactor.core.translations.components.Translation;
import net.impactdev.impactor.core.translations.components.resolvers.MultiLineTranslation;
import net.impactdev.impactor.core.translations.components.resolvers.SingleLineTranslation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TranslationSet {
    private final Map<String, Translation<?>> translations = Maps.newLinkedHashMap();

    public <T> Translation<T> translation(String key) {
        return this.translations.get(key);
    }

    public void register(String key, Translation<?> translation) {
        this.translations.put(key, translation);
    }

    public static TranslationSet fromJson(JsonObject json) throws Exception {
        TranslationSet result = new TranslationSet();
        TranslationSet.parse(result, null, json);
        return result;
    }

    private static void parse(@NotNull TranslationSet set, @Nullable String path, @NotNull JsonObject parent) {
        parent.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            Object target = path == null ? key : path + "." + key;
            if (element.isJsonObject()) {
                TranslationSet.parse(set, (String)target, element.getAsJsonObject());
            } else if (element.isJsonArray()) {
                JsonArray array = element.getAsJsonArray();
                ArrayList template = Lists.newArrayList();
                for (JsonElement value : array) {
                    if (!value.isJsonPrimitive()) {
                        throw new IllegalStateException("Invalid JSON target within array");
                    }
                    template.add(value.getAsString());
                }
                set.register((String)target, new MultiLineTranslation(template));
            } else if (element.isJsonPrimitive()) {
                set.register((String)target, new SingleLineTranslation(element.getAsString()));
            } else {
                throw new IllegalStateException("Reached a null field within JSON");
            }
        });
    }
}

